//
//  MCPDocument.h
//  MCApplication
//
//  Created by Michael Clark on 30/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCDocument.h"

#import <MCFoundation/MCSourceListDefines.h>

@class MCPDatabaseConnection, MCPObjectContext, MCLinkingContext;
@class MCUserDefaults;
@class MCCreationContext;
@class MCPObjectDeletionHandler;
@class MCPModel;

@interface MCPDocument : MCDocument {
	MCPDatabaseConnection*     _databaseConnection;
	MCPObjectContext*          _objectContext;
	
	MCLinkingContext*         _linkingContext;
}
- (void)importModelObject:(id)anObject;

- (void)setDatabaseConnection:(MCPDatabaseConnection *)conn;
- (MCPDatabaseConnection *)databaseConnection;

- (MCPObjectContext*)objectContext;
- (void)setObjectContext:(MCPObjectContext*)context;

- (MCLinkingContext *)linkingContext;
- (void)setLinkingContext:(MCLinkingContext *)aLinkingContext;

- (MCCreationContext*)creationContext;

- (MCPObjectDeletionHandler *)deletionHandler;

// This will *go to* the objects in the main window
- (void)showObjects:(NSArray *)array withModel:(id)aModel;
- (void)showObjects:(NSArray *)array;
- (void)showObject:(id)obj;

// This will open up the editing card for the given object(s), if more than one, than perhaps bulk edit?
- (void)editObjects:(NSArray *)array;

// Sends out notification (received by source list) to show objects, if a new window is requested, it deals with that as well(will in the future)
- (void)openObjects:(NSArray *)array inNewWindow:(BOOL)flag sender:(id)sender;
// Some things may need a root model in order to open, for instance if the connection is a many to many like a GWCorrespondence
- (void)openObjects:(NSArray *)array inNewWindow:(BOOL)flag sender:(id)sender withModel:(id)aModel;

- (BOOL)objectOpensInMainWindow:(id)anObj;

// This will smartly decide how and where to open a given object, should be overridden by subclassers if they want it to do 
// stuff for objects differently than in the above method
- (void)openObject:(id)anObj;

// Fetches object with entity name and id equal to arguments, then opens
- (void)openObjectWithEntityName:(NSString *)entityName primaryKeyID:(id)objectID inNewWindow:(BOOL)flag 
						  sender:(id)sender;
- (void)editObjectWithEntityName:(NSString *)entityName primaryKeyID:(id)objectID;
- (void)goToObjectWithEntityName:(NSString *)entityName primaryKeyID:(id)objectID;

- (MCUserDefaults *)userDefaults;

- (NSString *)documentName;
- (MCPModel *)model; // returns the model from the object context

- (void)createObjectForEntityName:(NSString *)anEntityName;

// Using the options cache, grabs all the options(i.e. GWCategory) for a particular key, as specified in the OptionsConfiguration.plist
- (NSArray *)optionsForKey:(NSString *)aKey;
- (id)optionForKey:(NSString *)aKey primaryKeyValue:(NSNumber *)aValue;

- (BOOL)checkCanEditObject:(id)anObj showErrorSheets:(BOOL)flag window:(NSWindow *)win;
- (BOOL)checkCanEditObject:(id)anObj;
- (BOOL)checkCanEditObjectAndPrepareForEdit:(id)anObj;
- (BOOL)checkCanEditObject:(id)anObj showErrorSheets:(BOOL)flag;
- (BOOL)checkCanEditObjectAndPrepareForEdit:(id)anObj showErrorSheets:(BOOL)flag;

- (void)runCreateNewSourceListEditorForIdentifier:(NSString *)ident sourceListType:(MCSourceListType)aType preLinkedObjects:(NSArray *)preLinkedObjs;
@end
